function T2limit = t2limit(m,ncomp,climit) 
% 
%   t2limit function estimates the T2 confidence limits for Hotelling's T^2.  
%   -------------------------------INPUT--------------------------------------
%   m           the number of samples used in the model         
%   ncomp       Number of componets (spectra) to fit.  
%   climit      The confidence limit expressed as a fraction
%           
%   -------------------------------OUTPUT-------------------------------------
%   T2limit        A value of the confidence limit
%
%   See also: pca_svd, qlimit
% 
% 	References: 
%   Jackson, J. E., & Mudholkar, G. S. (1979). Control Procedures for 
%   Residuals Associated with Principal Component Analysis. Technometrics, 
%   21(3), 341. doi:10.2307/1267757 
%
%   Bro, R., & Smilde, A. K. (2014). Principal component analysis. 
%   Anal. Methods, 6(9), 2812–2831. doi:10.1039/c3ay41907j 
%
%   This is a part of the GNAT        
%   Copyright  2017  <Mathias Nilsson>%
%   This program is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   This program is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License along
%   with this program; if not, write to the Free Software Foundation, Inc.,
%   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
%
%   Dr. Mathias Nilsson
%   School of Chemistry, University of Manchester,
%   Oxford Road, Manchester M13 9PL, UK
%   Telephone: +44 (0) 161 306 4465
%   Fax: +44 (0)161 275 4598
%   mathias.nilsson@manchester.ac.uk
%% 

T2limit=ncomp*(m-1)*finv(climit,ncomp,m-ncomp)./(m-ncomp);           
